from django.contrib import admin
from .models import Category, Article

@admin.register(Category)
class CategoryAdmin(admin.ModelAdmin):
    list_display = ('name', 'slug')
    prepopulated_fields = {'slug': ('name',)}

@admin.register(Article)
class ArticleAdmin(admin.ModelAdmin):
    list_display = ('title', 'category', 'status', 'published_at', 'author')
    list_filter = ('status', 'category', 'published_at')
    search_fields = ('title', 'content')
    prepopulated_fields = {'slug': ('title',)}
    date_hierarchy = 'published_at'
    
    # Organisation du formulaire
    fieldsets = (
        ('Méta', {
            'fields': ('title', 'slug', 'author', 'category')
        }),
        ('Contenu', {
            'fields': ('featured_image', 'excerpt', 'content')
        }),
        ('Publication', {
            'fields': ('status', 'published_at')
        }),
    )