# Generated by Django 3.2.23 on 2026-01-12 21:01

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('slug', models.SlugField(unique=True)),
            ],
            options={
                'verbose_name': 'Catégorie',
                'verbose_name_plural': 'Catégories',
            },
        ),
        migrations.CreateModel(
            name='Article',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='Titre')),
                ('slug', models.SlugField(max_length=200, unique=True, verbose_name='URL Slug')),
                ('excerpt', models.TextField(blank=True, help_text="Court résumé pour les cartes d'aperçu (SEO).", max_length=300, verbose_name='Extrait')),
                ('content', models.TextField(help_text="Le corps de l'article. Accepte le HTML brut.", verbose_name='Contenu HTML')),
                ('featured_image', models.ImageField(blank=True, null=True, upload_to='blog/images/', verbose_name='Image à la une')),
                ('status', models.CharField(choices=[('draft', 'Brouillon'), ('published', 'Publié')], default='draft', max_length=10)),
                ('published_at', models.DateTimeField(blank=True, null=True, verbose_name='Date de publication')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='articles', to=settings.AUTH_USER_MODEL, verbose_name='Auteur')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='articles', to='content.category', verbose_name='Catégorie')),
            ],
            options={
                'verbose_name': 'Article',
                'verbose_name_plural': 'Articles',
                'ordering': ['-published_at', '-created_at'],
            },
        ),
    ]
