from rest_framework import serializers
from .models import Article, Category
from apps.users.models import User

class CategorySerializer(serializers.ModelSerializer):
    class Meta:
        model = Category
        fields = ['id', 'name', 'slug']

class AuthorSerializer(serializers.ModelSerializer):
    """On n'expose que le nom public de l'auteur, pas son email/ID"""
    class Meta:
        model = User
        fields = ['first_name', 'last_name', 'username']

class ArticleListSerializer(serializers.ModelSerializer):
    """Serializer léger pour les listes (Home, Blog Index)"""
    category = CategorySerializer(read_only=True)
    author = AuthorSerializer(read_only=True)
    
    class Meta:
        model = Article
        fields = [
            'id', 'title', 'slug', 'excerpt', 
            'featured_image', 'category', 'author', 
            'published_at'
        ]

class ArticleDetailSerializer(serializers.ModelSerializer):
    """Serializer complet pour la page détail"""
    category = CategorySerializer(read_only=True)
    author = AuthorSerializer(read_only=True)

    class Meta:
        model = Article
        fields = [
            'id', 'title', 'slug', 'excerpt', 'content',
            'featured_image', 'category', 'author', 
            'published_at', 'updated_at'
        ]