from rest_framework import viewsets
from .models import Article, Category
from .serializers import ArticleListSerializer, ArticleDetailSerializer, CategorySerializer

class CategoryViewSet(viewsets.ReadOnlyModelViewSet):
    queryset = Category.objects.all()
    serializer_class = CategorySerializer
    lookup_field = 'slug'

class ArticleViewSet(viewsets.ReadOnlyModelViewSet):
    """
    API publique du blog.
    Ne renvoie que les articles PUBLIÉS.
    """
    lookup_field = 'slug'
    
    def get_queryset(self):
        # On filtre pour ne montrer que les articles publiés
        return Article.objects.filter(status='published')
    
    def get_serializer_class(self):
        if self.action == 'retrieve':
            return ArticleDetailSerializer
        return ArticleListSerializer