from django.contrib import admin
from adminsortable2.admin import SortableInlineAdminMixin
from .models import Menu, MenuItem

class MenuItemInline(SortableInlineAdminMixin, admin.TabularInline):
    model = MenuItem
    extra = 0
    fields = ('title', 'page', 'external_url', 'parent', 'order')
    # fk_name est nécessaire pour les relations récursives dans certains cas, mais ici 'menu' suffit.

@admin.register(Menu)
class MenuAdmin(admin.ModelAdmin):
    list_display = ('title', 'slug')
    prepopulated_fields = {'slug': ('title',)}
    inlines = [MenuItemInline]
    
    fieldsets = (
        (None, {
            'fields': ('title', 'slug')
        }),
    )

@admin.register(MenuItem)
class MenuItemAdmin(admin.ModelAdmin):
    """
    Permet de gérer les items individuellement si besoin (ex: pour des sous-menus complexes)
    """
    list_display = ('title', 'menu', 'parent', 'url', 'order')
    list_filter = ('menu',)
    search_fields = ('title',)
    ordering = ('menu', 'order')