from django.db import migrations

def create_menus(apps, schema_editor):
    Menu = apps.get_model('navigation', 'Menu')
    
    # 1. Navbar Principale
    Menu.objects.get_or_create(
        slug='main_navbar',
        defaults={'title': 'Navigation Principale'}
    )
    
    # 2. Footer
    Menu.objects.get_or_create(
        slug='footer_links',
        defaults={'title': 'Liens Pied de Page'}
    )
    
    # 3. Réseaux Sociaux
    Menu.objects.get_or_create(
        slug='social_links',
        defaults={'title': 'Réseaux Sociaux'}
    )

def reverse_create_menus(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('navigation', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_menus, reverse_create_menus),
    ]