from rest_framework import viewsets
from .models import Menu
from .serializers import MenuSerializer

class MenuViewSet(viewsets.ReadOnlyModelViewSet):
    """
    Accès en lecture seule aux menus.
    Lookup field = 'slug' (ex: /api/navigation/menus/navbar/)
    """
    queryset = Menu.objects.prefetch_related('items__children').all()
    serializer_class = MenuSerializer
    lookup_field = 'slug'