from django.db import migrations

def populate_about(apps, schema_editor):
    Page = apps.get_model('pages', 'Page')
    Section = apps.get_model('sections', 'Section')

    # 1. Récupération de la page À Propos
    try:
        page = Page.objects.get(slug='a-propos')
    except Page.DoesNotExist:
        return # Sécurité

    # 2. Nettoyage préventif
    Section.objects.filter(page=page).delete()

    # =========================================================
    # SECTION 1 : HERO SIMPLE (L'Accroche)
    # =========================================================
    Section.objects.create(
        page=page,
        type='hero_simple',
        internal_name="Hero À Propos",
        order=1,
        data={
            "title": "L'union des expertises techniques.",
            "subtitle": "Née de la convergence de talents indépendants, notre agence porte une vision commune : l'excellence sans compromis.",
            "background_color": "bg-dark" # Classe utilitaire CSS potentielle
        }
    )

    # =========================================================
    # SECTION 2 : TIMELINE (L'Histoire)
    # =========================================================
    Section.objects.create(
        page=page,
        type='timeline',
        internal_name="Notre Histoire",
        order=2,
        data={
            "items": [
                {
                    "year": "2022 - 2024",
                    "title": "L'Ère de l'Expertise Individuelle",
                    "description": "Chaque membre fondateur évolue en freelance sur des projets d'envergure. C'est le temps de l'acquisition d'expérience : architectures complexes, gestion de la dette technique et maîtrise des stacks modernes (Django, React, Cloud)."
                },
                {
                    "year": "Fin 2024",
                    "title": "La Convergence",
                    "description": "Le constat est unanime : les projets les plus ambitieux nécessitent une force de frappe collective. Les freelances commencent à collaborer, unissant leurs compétences Backend, Frontend et DevOps."
                },
                {
                    "year": "2025",
                    "title": "La Naissance de l'Agence",
                    "description": "Officialisation de la structure. Nous passons du statut d'indépendants à celui de partenaire technologique global, capable de délivrer des produits SaaS et E-commerce complets."
                }
            ]
        }
    )

    # =========================================================
    # SECTION 3 : VALUES GRID (L'Instinct Tech)
    # =========================================================
    Section.objects.create(
        page=page,
        type='values_grid',
        internal_name="Nos Valeurs",
        order=3,
        data={
            "items": [
                {
                    "title": "Architecture First",
                    "description": "Nous ne codons pas à la va-vite. Nous concevons des fondations solides, scalables et maintenables sur le long terme.",
                    "icon": "fa-drafting-compass"
                },
                {
                    "title": "Transparence Radicale",
                    "description": "Pas de boîte noire. Vous avez accès au code, aux processus et nous communiquons franchement sur les défis techniques.",
                    "icon": "fa-eye"
                },
                {
                    "title": "Pragmatisme",
                    "description": "Nous détestons la complexité inutile. Nous choisissons la technologie la plus adaptée à votre besoin business, pas la plus 'hype'.",
                    "icon": "fa-cogs"
                }
            ]
        }
    )

    # =========================================================
    # SECTION 4 : TEAM GRID (Template pour toi)
    # =========================================================
    Section.objects.create(
        page=page,
        type='team_grid',
        internal_name="L'Équipe (Template)",
        order=4,
        data={
            "title": "Ceux qui construisent vos produits",
            "members": [
                {
                    "name": "Votre Nom",
                    "role": "Lead Architect & Founder",
                    "photo_main": "/media/team/founder_placeholder.jpg",
                    "linkedin_url": "https://linkedin.com",
                    "github_url": "https://github.com",
                    "portfolio_url": "https://mon-portfolio.com"
                },
                {
                    "name": "Membre Tech",
                    "role": "Senior Developer",
                    "photo_main": "/media/team/member_placeholder.jpg",
                    "linkedin_url": ""
                }
            ]
        }
    )

    # =========================================================
    # SECTION 5 : MANIFESTE (Vision finale)
    # =========================================================
    Section.objects.create(
        page=page,
        type='text_block',
        internal_name="Vision",
        order=5,
        data={
            "align": "center",
            "content": """
            <h3>Pourquoi nous existons ?</h3>
            <p>Le marché est saturé d'agences qui vendent du rêve mais livrent du code jetable. 
            Nous avons créé cette structure pour offrir une alternative : <strong>l'artisanat logiciel à l'échelle industrielle</strong>.</p>
            <p>Nous croyons que la technologie bien conçue est un levier de croissance infini, et nous sommes là pour l'actionner avec vous.</p>
            """
        }
    )
    
    # =========================================================
    # SECTION 6 : CTA
    # =========================================================
    Section.objects.create(
        page=page,
        type='cta',
        internal_name="CTA Bas",
        order=6,
        data={
            "title": "Envie de rejoindre l'aventure ?",
            "text": "Que vous soyez un client ambitieux ou un talent tech, nos portes sont ouvertes.",
            "btn_text": "Contactez-nous",
            "btn_url": "/contact"
        }
    )

def reverse_populate_about(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('pages', '0004_populate_home_content'), # Doit s'exécuter après la home
        ('sections', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(populate_about, reverse_populate_about),
    ]