"""
Définitions des types de sections disponibles dans le CMS.
Registre complet pour toutes les pages (Home, About, Services, Blog, Contact).
"""

from django.db import models
from django.utils.translation import gettext_lazy as _

class SectionType(models.TextChoices):
    # --- 1. HEROS (Bannières) ---
    HERO_SLIDER = 'hero_slider', _('Hero Slider (Carrousel)')
    HERO_SIMPLE = 'hero_simple', _('Hero Simple (Titre centré)')
    HERO_BLOG = 'hero_blog', _('Hero Blog (Dernier article mis en avant)')
    
    # --- 2. CONTENU TEXTUEL & STRUCTURE ---
    TEXT_BLOCK = 'text_block', _('Bloc Texte Riche')
    VALUES_GRID = 'values_grid', _('Grille de Valeurs (Cartes 3D)')
    ACCORDION = 'accordion', _('Accordéon / FAQ')
    TIMELINE = 'timeline', _('Chronologie (Histoire)')
    
    # --- 3. PRÉSENTATION VISUELLE ---
    FEATURES = 'features', _('Grille de Fonctionnalités (Bento)')
    FEATURES_ALTERNATING = 'features_alternating', _('Fonctionnalités Alternées (Img/Txt)')
    PROCESS_STEPS = 'process_steps', _('Processus (Sticky Scroll)')
    IMAGE_GALLERY = 'image_gallery', _('Galerie Images (Masonry)')
    
    # --- 4. CONFIANCE & ÉQUIPE ---
    LOGO_CLOUD = 'logo_cloud', _('Barre de Logos (Partenaires)')
    STATS = 'stats', _('Chiffres Clés (Key Metrics)')
    TESTIMONIALS = 'testimonials', _('Carrousel Témoignages')
    TEAM_GRID = 'team_grid', _('Grille Équipe (Effet Hover)')
    
    # --- 5. MARKETING & CONVERSION ---
    PRICING_TABLE = 'pricing_table', _('Tableaux de Prix')
    CTA = 'cta', _('Appel à l\'action (CTA Final)')
    NEWSLETTER_FORM = 'newsletter_form', _('Inscription Newsletter')
    
    # --- 6. CONTACT ---
    CONTACT_SPLIT = 'contact_split', _('Contact (Infos + Formulaire)')
    
    # --- 7. DYNAMIQUE (CONNECTEURS) ---
    LATEST_POSTS = 'latest_posts', _('Liste des Derniers Articles')

    # NOUVEAUX TYPES :
    PORTFOLIO_GRID = 'portfolio_grid', _('Grille des Projets (Portfolio)')
    SERVICES_LIST = 'services_list', _('Liste des Services (Cards)')