from django.db import transaction
from .models import Section

class SectionService:
    """
    Service pour la gestion complexe des sections.
    Sera très utile pour le Chatbot/IA qui devra générer des sections.
    """

    @staticmethod
    def create_section(page, section_type, data, internal_name=""):
        """
        Crée une section proprement avec validation.
        """
        section = Section(
            page=page,
            type=section_type,
            data=data,
            internal_name=internal_name
        )
        # La validation clean() sera appelée par save() grâce à notre surcharge
        section.save()
        return section

    @staticmethod
    def reorder_sections(page, section_ids):
        """
        Réordonne les sections d'une page selon une liste d'IDs.
        """
        with transaction.atomic():
            for index, section_id in enumerate(section_ids):
                Section.objects.filter(
                    id=section_id, 
                    page=page
                ).update(order=index)