from django.db import migrations

def create_settings(apps, schema_editor):
    GlobalSettings = apps.get_model('settings_site', 'GlobalSettings')
    
    if not GlobalSettings.objects.exists():
        GlobalSettings.objects.create(
            site_name="Imagin.K",
            contact_email="contact@imagink.agency",
            social_links={
                "linkedin": "https://linkedin.com",
                "twitter": "https://x.com"
            }
        )

def reverse_create_settings(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('settings_site', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_settings, reverse_create_settings),
    ]