from rest_framework.views import APIView
from rest_framework.response import Response
from .models import GlobalSettings
from .serializers import GlobalSettingsSerializer

class GlobalSettingsView(APIView):
    """
    Renvoie toujours la configuration unique du site.
    Pas d'authentification requise (c'est public).
    """
    def get(self, request, format=None):
        # On récupère le premier objet ou on en crée un vide si inexistant (sécurité)
        settings_obj, created = GlobalSettings.objects.get_or_create(id=1)
        serializer = GlobalSettingsSerializer(settings_obj, context={'request': request})
        return Response(serializer.data)