import pytest
from unittest.mock import patch
from rest_framework.test import APIClient

@pytest.mark.django_db
class TestChatbotAPI:
    
    def setup_method(self):
        self.client = APIClient()
        self.url = '/api/chatbot/message/'

    def test_chatbot_validation_error(self):
        """Vérifie qu'on ne peut pas envoyer un message vide"""
        response = self.client.post(self.url, {}, format='json')
        assert response.status_code == 400 # Bad Request

    @patch('apps.chatbot.views.get_ai_response') 
    def test_chatbot_success(self, mock_ai_service):
        """
        Test le succès sans appeler OpenRouter.
        On remplace le service par un faux qui renvoie une réponse fixe.
        """
        # Configuration du Mock
        mock_ai_service.return_value = {
            "reply": "Ceci est une réponse simulée.",
            "conversation_uuid": "1234-5678"
        }

        payload = {"message": "Bonjour !"}
        response = self.client.post(self.url, payload, format='json')

        assert response.status_code == 200
        data = response.json()
        assert data['reply'] == "Ceci est une réponse simulée."
        # Vérifie que notre vue a bien appelé le service
        mock_ai_service.assert_called_once()