import pytest
from rest_framework.test import APIClient
from apps.navigation.models import Menu, MenuItem
from apps.pages.models import Page

@pytest.mark.django_db
class TestNavigationAPI:
    
    def setup_method(self):
        self.client = APIClient()
        
        # Page pour lien interne
        self.page = Page.objects.create(title="Ma Page", slug="ma-page", is_published=True)
        
        # Menu Principal
        self.menu = Menu.objects.create(title="Navbar", slug="main_navbar")
        
        # Item 1 : Lien Interne (Parent)
        self.item_parent = MenuItem.objects.create(
            menu=self.menu, title="Parent", page=self.page, order=1
        )
        
        # Item 2 : Lien Externe (Enfant)
        self.item_child = MenuItem.objects.create(
            menu=self.menu, parent=self.item_parent, 
            title="Enfant", external_url="https://google.com", order=1
        )

    def test_menu_structure_recursion(self):
        """Vérifie que l'enfant est bien imbriqué dans le parent"""
        response = self.client.get('/api/navigation/menus/main_navbar/')
        assert response.status_code == 200
        data = response.json()
        
        items = data['items']
        assert len(items) == 1 # Seulement le parent au niveau 1
        
        parent = items[0]
        assert parent['title'] == 'Parent'
        # Vérification URL dynamique
        assert parent['url'] == '/ma-page'
        
        # Vérification des enfants
        assert len(parent['children']) == 1
        child = parent['children'][0]
        assert child['title'] == 'Enfant'
        assert child['url'] == 'https://google.com'