import pytest
from django.urls import reverse
from rest_framework.test import APIClient
from apps.pages.models import Page
from apps.sections.models import Section

# Ce décorateur donne accès à la base de données pour le test
@pytest.mark.django_db
class TestPagesAPI:
    
    def setup_method(self):
        self.client = APIClient()
        # On crée une page fictive pour le test (indépendante des migrations)
        self.page = Page.objects.create(
            title="Test Home",
            slug="test-home",
            is_published=True
        )
        # On lui ajoute une section
        Section.objects.create(
            page=self.page,
            type="hero_simple",
            data={"title": "Hello World"}
        )

    def test_get_page_detail_success(self):
        """Vérifie qu'on peut récupérer une page par son slug"""
        url = f'/api/pages/{self.page.slug}/'
        response = self.client.get(url)
        
        assert response.status_code == 200
        data = response.json()
        
        # Vérification de la structure
        assert data['slug'] == 'test-home'
        assert 'sections' in data
        assert len(data['sections']) == 1
        assert data['sections'][0]['type'] == 'hero_simple'

    def test_get_page_not_found(self):
        """Vérifie la 404 pour une page inexistante"""
        response = self.client.get('/api/pages/page-imaginaire/')
        assert response.status_code == 404