import pytest
from rest_framework.test import APIClient
from apps.settings_site.models import GlobalSettings

@pytest.mark.django_db
class TestSettingsAPI:
    
    def setup_method(self):
        self.client = APIClient()

    def test_get_global_settings_auto_create(self):
        """Vérifie que l'objet est créé à la volée s'il n'existe pas"""
        # On s'assure que la base est vide
        GlobalSettings.objects.all().delete()
        
        response = self.client.get('/api/settings/global/')
        assert response.status_code == 200
        
        data = response.json()
        # Vérifie les valeurs par défaut définies dans le modèle
        assert data['site_name'] == "Mon Site Headless" 
        assert GlobalSettings.objects.count() == 1

    def test_settings_content(self):
        """Vérifie qu'on récupère bien les données modifiées"""
        # 1. On nettoie la base pour être sûr qu'il n'y a pas d'ancien settings
        GlobalSettings.objects.all().delete()

        # 2. On crée le singleton avec l'ID=1 explicitement car la Vue attend cet ID
        GlobalSettings.objects.create(
            id=1, 
            site_name="Agence Test",
            contact_email="test@agence.com",
            social_links={"twitter": "https://x.com/test"}
        )
        
        response = self.client.get('/api/settings/global/')
        data = response.json()
        
        # Maintenant ça doit matcher !
        assert data['site_name'] == "Agence Test"
        assert data['social_links']['twitter'] == "https://x.com/test"