import pytest
from rest_framework.test import APIClient
from apps.pages.models import Page
from apps.content.models import Article

@pytest.mark.django_db
class TestSecurityAPI:
    
    def setup_method(self):
        self.client = APIClient() # Client ANONYME (pas de login)
        
        # On crée des données à protéger
        self.page = Page.objects.create(title="Page Home", slug="home", is_published=True)

    def test_anonymous_cannot_create_page(self):
        """Un anonyme ne doit PAS pouvoir créer une page"""
        response = self.client.post('/api/pages/', {
            "title": "Hacked Page",
            "slug": "hacked"
        })
        # On attend 403 Forbidden ou 401 Unauthorized
        assert response.status_code in [401, 403]
        assert Page.objects.count() == 1 # Rien n'a été créé

    def test_anonymous_cannot_delete_page(self):
        """Un anonyme ne doit PAS pouvoir supprimer une page"""
        response = self.client.delete(f'/api/pages/{self.page.slug}/')
        
        assert response.status_code in [401, 403]
        assert Page.objects.filter(slug="home").exists() # La page est toujours là

    def test_anonymous_cannot_create_article(self):
        """Un anonyme ne doit PAS pouvoir poster un article"""
        response = self.client.post('/api/blog/articles/', {
            "title": "Spam Article",
            "content": "Buy Crypto"
        })
        assert response.status_code in [401, 403]