import pytest
from apps.sections.serializers import HeroSliderSerializer, StatsSerializer

class TestSectionSerializers:
    
    def test_hero_slider_validation_valid(self):
        """Doit accepter un slider complet"""
        data = {
            "autoplay": True,
            "slides": [
                {"title": "Slide 1", "btn_primary_text": "Click"}
            ]
        }
        serializer = HeroSliderSerializer(data=data)
        assert serializer.is_valid()

    def test_hero_slider_validation_invalid(self):
        """Doit refuser si 'slides' est manquant"""
        data = {
            "autoplay": True
            # 'slides' est required=True
        }
        serializer = HeroSliderSerializer(data=data)
        assert not serializer.is_valid()
        assert 'slides' in serializer.errors

    def test_stats_serializer(self):
        """Vérifie la validation des statistiques"""
        data = {
            "style": "dark",
            "items": [
                {"value": "100", "label": "Clients"} # OK
            ]
        }
        serializer = StatsSerializer(data=data)
        assert serializer.is_valid()